@extends('layout')
@section('title')
    <title>{{ __('translate.Edit Profile') }}</title>
@endsection
@section('body-content')

<main>

        <!-- inner-bg  part start  -->

        <div class="inner-bg common-class"
        style="    background-image:  url({{ custom_asset($breadcrumb, '1905x408') }});">
        <div class="container">
            <div class="row">
                <div class="col-lg-3">

                    <div class="inner-bg-txt">
                        <h1>{{ __('translate.Edit Profile') }}</h1>

                        <ul>
                            <li><a href="{{ route('home') }}">{{ __('translate.Home') }}</a></li>
                            <li><span>
                                    <svg width="6" height="12" viewBox="0 0 6 12" fill="none"
                                        xmlns="http://www.w3.org/2000/svg">
                                        <path
                                            d="M0.633816 2.7705e-08C0.446997 0.0532405 0.28353 0.143084 0.158011 0.319443C-0.0492418 0.618921 -0.0550799 1.0515 0.155092 1.35098C0.195958 1.40755 0.239744 1.46411 0.286449 1.51735C1.56499 2.97481 2.84645 4.4356 4.125 5.89306C4.15419 5.92633 4.18922 5.95295 4.24176 6.03281C4.20673 6.0561 4.16295 6.06941 4.13375 6.10269C2.84062 7.57346 1.5504 9.04755 0.257258 10.5183C0.0295721 10.7779 -0.0579994 11.0773 0.0412483 11.4367C0.187201 11.9591 0.776848 12.1721 1.16216 11.8427C1.20595 11.8061 1.24682 11.7628 1.28768 11.7196C2.7764 10.0225 4.26511 8.32881 5.75091 6.63177C6.02238 6.32231 6.07492 5.92966 5.89394 5.57361C5.85015 5.4871 5.78594 5.41056 5.72464 5.34069C4.27971 3.69356 2.83478 2.04976 1.39277 0.399304C1.23222 0.216289 1.06875 0.0532405 0.838149 3.66367e-08C0.771011 3.3702e-08 0.703873 3.07673e-08 0.633816 2.7705e-08Z" />
                                    </svg>

                                </span></li>
                            <li><a href="javascript:;" class="active">{{ __('translate.Edit Profile') }}</a></li>
                        </ul>
                    </div>

                </div>
            </div>
        </div>
    </div>

    <!-- inner-bg  part end  -->




    <!-- dashboard-part-start -->
    <section class="dashboard footer-top-pad ">
        <div class="container">
            <div class="row">

                @include('profile.sidebar')


                <div class=" col-xxl-9 col-xl-8 col-lg-8">
                    <form action="{{ route('user.update-profile') }}" enctype="multipart/form-data" method="POST">
                        @csrf
                        @method('PUT')
                    <div class="row g-3">
                        <div class="col-lg-12">
                            <div class="car-images">
                                <h3 class="car-images-taitel">{{ __('translate.Upload Avatar and Resume') }}</h3>

                                <div class="row ">
                                    <div class="col-md-4">
                                        <div class="car-images-inner two">
                                            <label class="form-label">{{ __('translate.My Avatar') }}

                                                <i 
                                                    class="fas fa-info-circle text-info"
                                                    data-toggle="tooltip"
                                                    data-placement="right"
                                                    title="Recommended size: 92x92"
                                                    style="cursor: pointer;"
                                                ></i>
                                                </label>
                                            <div class="uplode-thumb-main">
                                                <div class="uplode-thumb">
                                                    @if($user->image)
                                                        <img id="preview-user-avatar-edit-page" src="{{ custom_asset($user->image, '48x48') }}" alt="thumb">
                                                    @else
                                                        <img id="preview-user-avatar-edit-page" src="{{ custom_asset($setting->placeholder_image, '48x48') }}" alt="thumb">
                                                    @endif

                                                </div>
                                                <div class="uplode-thumb-main-item">
                                                    <p>{{ __('translate.Select') }} <span>{{ __('translate.New File') }}</span> {{ __('translate.to Upload') }}</p>
                                                    <input type="file" id="my-file" name="image" onchange="previewEditPageImage(event)">
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-md-8 ">
                                        <div class="uplode-vedio das">
                                            <label class="form-label">{{ __('translate.My Resume') }}
                                                @if ($user->resume)
                                                <a href="{{ route('download-resume', $user->resume) }}">({{ __('translate.Download Resume') }})</a> </label>
                                                @endif
                                            <div class="uplode-vedio-item">

                                                <div class="uplode-vedio-inner">
                                                    <div class="uplode-vedio-inner-img">
                                                        <img src="{{ custom_asset($setting->placeholder_image, '693x278') }}" alt="img" id="resume_preview">
                                                    </div>
                                                    <div class="uplode-vedio-inner-text">
                                                        <h6>{{ __('translate.Select') }} <span>{{ __('translate.New File') }}</span> {{ __('translate.to Upload') }} </h6>
                                                    </div>

                                                </div>

                                                <input type="file" class="uplode-vedio" name="resume" accept="application/pdf">
                                            </div>
                                        </div>
                                    </div>
                                </div>

                            </div>
                        </div>

                        <div class="col-lg-12">
                            <div class="car-images">
                                <h3 class="car-images-taitel">{{ __('translate.Basic Information') }}</h3>

                                <div class="car-images-inner">
                                    <div class="description-item">

                                        <div class="description-item-inner">
                                            <label class="form-label">{{ __('translate.Name') }}
                                                <span>*</span> </label>
                                            <input type="text" class="form-control"
                                            placeholder="{{ __('translate.Name') }}" name="name" value="{{ html_decode($user->name) }}">
                                        </div>

                                        <div class="description-item-inner">
                                            <label class="form-label">{{ __('translate.Designation') }}
                                                 </label>
                                            <input type="text" class="form-control"
                                            placeholder="{{ __('translate.Designation') }}" name="designation" value="{{ html_decode($user->designation) }}">
                                        </div>
                                    </div>

                                    <div class="description-item">

                                        <div class="description-item-inner">
                                            <label class="form-label">{{ __('translate.Email Address') }}
                                                <span>*</span> </label>
                                            <input type="email" class="form-control"
                                                placeholder="{{ __('translate.Email Address') }}"  name="email" value="{{ html_decode($user->email) }}" readonly>
                                        </div>

                                        <div class="description-item-inner">
                                            <label class="form-label">{{ __('translate.Phone Number') }}
                                                <span>*</span> </label>
                                            <input type="text" class="form-control"
                                                placeholder="{{ __('translate.Phone Number') }}" value="{{ html_decode($user->phone) }}"  name="phone">
                                        </div>
                                    </div>

                                    <div class="description-item">
                                        <div class="description-item-inner">
                                            <label class="form-label">{{ __('translate.Whatsapp Number') }}
                                                 </label>
                                            <input type="text" class="form-control"
                                                placeholder="{{ __('translate.Whatsapp Number') }}" value="{{ html_decode($user->whatsapp_phone) }}"  name="whatsapp_phone">
                                        </div>

                                        <div class="description-item-inner">
                                            <label class="form-label">{{ __('translate.Address') }}
                                                <span>*</span> </label>
                                            <input type="text" class="form-control"
                                                placeholder="{{ __('translate.Address') }}" value="{{ html_decode($user->address) }}"  name="address">
                                        </div>

                                    </div>

                                    <div class="description-item">

                                        <div class="description-item-inner about_us_textarea">
                                            <label class="form-label">{{ __('translate.Google Embed Map Link') }}
                                                 </label>
                                            <textarea name="google_map" class="form-control" id="" cols="30" rows="5">{{ html_decode($user->google_map) }}</textarea>
                                        </div>

                                    </div>

                                    <div class="description-item">

                                        <div class="description-item-inner about_us_textarea">
                                            <label class="form-label">{{ __('translate.About Us') }}
                                                 </label>
                                            <textarea name="about_me" class="form-control" id="" cols="30" rows="5">{{ html_decode($user->about_me) }}</textarea>
                                        </div>

                                    </div>

                                </div>
                            </div>
                        </div>


                        <div class="col-lg-12">
                            <div class="car-images ">
                                <h3 class="car-images-taitel">{{ __('translate.Social Link') }}</h3>

                                <div class="join-a-dealer-form-main two">

                                    <div class="join-a-dealer-form-item">

                                        <div class="join-a-dealer-form-inner">

                                            <label for="exampleFormControlInput10" class="form-label">{{ __('translate.Instagram') }}
                                                </label>

                                            <input type="text" class="form-control" id="exampleFormControlInput10"
                                                placeholder="{{ __('translate.Instagram') }}" name="instagram" value="{{ html_decode($user->instagram) }}">

                                            <div class="icon">
                                                <span>
                                                    <svg width="20" height="20" viewBox="0 0 20 20" fill="none"
                                                        xmlns="http://www.w3.org/2000/svg">
                                                        <path fill-rule="evenodd" clip-rule="evenodd"
                                                            d="M5 0C2.23858 0 0 2.23858 0 5V15C0 17.7614 2.23858 20 5 20H15C17.7614 20 20 17.7614 20 15V5C20 2.23858 17.7614 0 15 0H5ZM16 5C16.5523 5 17 4.55228 17 4C17 3.44772 16.5523 3 16 3C15.4477 3 15 3.44772 15 4C15 4.55228 15.4477 5 16 5ZM15 10C15 12.7614 12.7614 15 10 15C7.23858 15 5 12.7614 5 10C5 7.23858 7.23858 5 10 5C12.7614 5 15 7.23858 15 10ZM10 13C11.6569 13 13 11.6569 13 10C13 8.34315 11.6569 7 10 7C8.34315 7 7 8.34315 7 10C7 11.6569 8.34315 13 10 13Z" />
                                                    </svg>
                                                </span>
                                            </div>
                                        </div>

                                        <div class="join-a-dealer-form-inner">

                                            <label for="exampleFormControlInput11" class="form-label">{{ __('translate.Facebook') }}
                                                </label>

                                            <input type="text" class="form-control" id="exampleFormControlInput11"
                                            placeholder="{{ __('translate.Facebook') }}" name="facebook" value="{{ html_decode($user->facebook) }}">

                                            <div class="icon">
                                                <span>
                                                    <svg width="20" height="20" viewBox="0 0 20 20" fill="none"
                                                        xmlns="http://www.w3.org/2000/svg">
                                                        <path
                                                            d="M16 0H4C1.79086 0 0 1.79086 0 4V16C0 18.2091 1.79086 20 4 20H8.5V14H5V11H8.5V9C8.5 6.79086 10.2909 5 12.5 5H15V8H12.5C11.9477 8 11.5 8.44772 11.5 9V11H15V14H11.5V20H16C18.2091 20 20 18.2091 20 16V4C20 1.79086 18.2091 0 16 0Z" />
                                                    </svg>
                                                </span>
                                            </div>
                                        </div>

                                    </div>

                                    <div class="join-a-dealer-form-item">

                                        <div class="join-a-dealer-form-inner">

                                            <label for="exampleFormControlInput13" class="form-label">{{ __('translate.LinkedIn') }}
                                                </label>

                                            <input type="text" class="form-control" id="exampleFormControlInput13"
                                            placeholder="{{ __('translate.LinkedIn') }}" name="linkedin" value="{{ html_decode($user->linkedin) }}">

                                            <div class="icon">
                                                <span>
                                                    <svg width="19" height="20" viewBox="0 0 19 20" fill="none"
                                                        xmlns="http://www.w3.org/2000/svg">
                                                        <path fill-rule="evenodd" clip-rule="evenodd"
                                                            d="M4 2C4 3.10457 3.10457 4 2 4C0.895431 4 0 3.10457 0 2C0 0.895431 0.895431 0 2 0C3.10457 0 4 0.895431 4 2ZM4 6.5V20H0V6.5H4ZM7 6.5H11V7.34141C11.6256 7.12031 12.2987 7 13 7C16.3137 7 19 9.68629 19 13V20H15V13C15 11.8954 14.1046 11 13 11C11.8954 11 11 11.8954 11 13V20H7V13V6.5Z" />
                                                    </svg>
                                                </span>
                                            </div>
                                        </div>

                                        <div class="join-a-dealer-form-inner">

                                            <label for="exampleFormControlInput5" class="form-label">{{ __('translate.Twitter') }}
                                                </label>

                                            <input type="text" class="form-control" id="exampleFormControlInput5"
                                            placeholder="{{ __('translate.Twitter') }}" name="twitter" value="{{ html_decode($user->twitter) }}">

                                            <div class="icon">
                                                <span>
                                                    <svg width="18" height="16" viewBox="0 0 18 16" fill="none"
                                                        xmlns="http://www.w3.org/2000/svg">
                                                        <path
                                                            d="M12.2863 0C10.1825 0 8.47695 1.79086 8.47695 4C8.47695 4.33382 8.5159 4.65809 8.58927 4.96808C6.56635 4.96808 3.51939 4.55908 0.974682 2.00961C0.636299 1.67059 0.0123287 1.89726 0.0358001 2.37567C0.412925 10.0627 3.70501 12.3049 5.40034 12.4444C4.3056 13.5257 2.71534 14.3791 1.11513 14.7622C0.692808 14.8633 0.58848 15.3256 1.00144 15.4599C2.14647 15.8323 3.78541 15.9758 4.66759 16C10.9084 16 15.9809 10.7471 16.0938 4.22229C16.9131 3.68945 17.438 2.5325 17.7329 1.71291C17.8047 1.5133 17.4775 1.28073 17.2817 1.36226C16.6696 1.61708 15.8926 1.67749 15.2306 1.46181C14.532 0.569266 13.4725 0 12.2863 0Z" />
                                                    </svg>
                                                </span>
                                            </div>
                                        </div>

                                    </div>

                                </div>

                            </div>
                        </div>

                        <div class="col-lg-12">
                            <div class="car-images ">
                                <h3 class="car-images-taitel">{{ __('translate.Working Days') }}</h3>
                                <div class="join-a-dealer-form-main two">

                                    <div class="join-a-dealer-form-item">

                                        <div class="join-a-dealer-form-inner">

                                            <label for="exampleFormControlInput16" class="form-label">{{ __('translate.Sunday') }}
                                                </label>

                                            <input type="text" class="form-control" id="exampleFormControlInput16"
                                                placeholder="{{ __('translate.Sunday') }}" name="sunday" value="{{ html_decode($user->sunday) }}">
                                        </div>

                                        <div class="join-a-dealer-form-inner">

                                            <label for="exampleFormControlInput17" class="form-label">{{ __('translate.Monday') }}
                                                </label>

                                            <input type="text" class="form-control" id="exampleFormControlInput17"
                                            placeholder="{{ __('translate.Monday') }}" name="monday" value="{{ html_decode($user->monday) }}">

                                        </div>

                                    </div>



                                    <div class="join-a-dealer-form-item">

                                        <div class="join-a-dealer-form-inner">

                                            <label for="exampleFormControlInput18" class="form-label">{{ __('translate.Tuesday') }}
                                                </label>

                                            <input type="text" class="form-control" id="exampleFormControlInput18"
                                            placeholder="{{ __('translate.Tuesday') }}" name="tuesday" value="{{ html_decode($user->tuesday) }}">

                                        </div>

                                        <div class="join-a-dealer-form-inner">

                                            <label for="exampleFormControlInput19" class="form-label">{{ __('translate.Wednesday') }}
                                                </label>

                                            <input type="text" class="form-control" id="exampleFormControlInput19"
                                            placeholder="{{ __('translate.Wednesday') }}" name="wednesday" value="{{ html_decode($user->wednesday) }}">

                                        </div>

                                    </div>

                                    <div class="join-a-dealer-form-item">

                                        <div class="join-a-dealer-form-inner">

                                            <label for="exampleFormControlInput20" class="form-label">{{ __('translate.Thursday') }}
                                                </label>

                                            <input type="text" class="form-control" id="exampleFormControlInput20"
                                            placeholder="{{ __('translate.thursday') }}" name="thursday" value="{{ html_decode($user->thursday) }}">

                                        </div>

                                        <div class="join-a-dealer-form-inner">

                                            <label for="exampleFormControlInput21" class="form-label">{{ __('translate.Friday') }}
                                                </label>

                                            <input type="text" class="form-control" id="exampleFormControlInput21"
                                            placeholder="{{ __('translate.Friday') }}" name="friday" value="{{ html_decode($user->friday) }}">

                                        </div>

                                    </div>

                                    <div class="join-a-dealer-form-item">

                                        <div class="join-a-dealer-form-inner">

                                            <label for="exampleFormControlInput22" class="form-label">{{ __('translate.Saturday') }}
                                                </label>

                                            <input type="text" class="form-control" id="exampleFormControlInput22"
                                            placeholder="{{ __('translate.Saturday') }}" name="saturday" value="{{ html_decode($user->saturday) }}">

                                        </div>


                                    </div>


                                </div>
                            </div>
                        </div>


                        <div class="col-lg-12">
                            <button type="submit" class="main-btn update_profile_btn">{{ __('translate.Update Profile') }}</button>
                        </div>
                    </form>



                    </div>
                </div>
            </div>
        </div>
        </div>
    </section>

    <!-- dashboard-part-end -->


    @include('profile.logout')


</main>

@endsection



@push('js_section')
<script>
    "use strict";

    function previewEditPageImage(event) {
        var reader = new FileReader();
        reader.onload = function(){
            var output = document.getElementById('preview-user-avatar-edit-page');
            output.src = reader.result;
        }

        reader.readAsDataURL(event.target.files[0]);
    };

</script>

@endpush
